/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.common;

import ibm.nways.jdm.common.DisplayHint;
import ibm.nways.jdm.common.Hex;
import java.io.Serializable;

public class DisplayHint
implements Serializable {
    private static final boolean debug = false;

    public static String stringFromHint(String string, long l) {
        String string2 = null;
        if (string != null) {
            if (string.length() == 1) {
                if (Character.toLowerCase(string.charAt(0)) == 'x') {
                    string2 = Long.toHexString(l);
                } else if (Character.toLowerCase(string.charAt(0)) == 'd') {
                    string2 = Long.toString(l);
                } else if (Character.toLowerCase(string.charAt(0)) == 'o') {
                    string2 = Long.toOctalString(l);
                } else if (Character.toLowerCase(string.charAt(0)) == 'b') {
                    string2 = Long.toBinaryString(l);
                }
            } else if (string.length() > 0 && Character.toLowerCase(string.charAt(0)) == 'd' && string.charAt(1) == '-' && Character.isDigit(string.charAt(2))) {
                double d = 10.0;
                Integer n = new Integer(string.substring(2));
                double d2 = n.doubleValue();
                Long l2 = new Long(l);
                double d3 = l2.doubleValue();
                if (d2 >= 0.0) {
                    string2 = Double.toString(d3 /= Math.pow(d, d2));
                }
            }
        }
        return string2;
    }

    public static String stringFromHint(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 1;
        1.SeqInfo seqInfo = new 1.SeqInfo(string);
        while (n < byArray.length) {
            if (seqInfo.isSeqRepeated()) {
                n2 = byArray[n];
                ++n;
            }
            while (n < byArray.length && n2 > 0) {
                int n3 = n + seqInfo.length() <= byArray.length ? seqInfo.length() : byArray.length - n;
                if (seqInfo.isSeqHex()) {
                    String string2 = Hex.toString(byArray, n, n3);
                    stringBuffer.append(string2);
                } else if (seqInfo.isSeqDec()) {
                    String string3 = Hex.toString(byArray, n, n3, 10);
                    stringBuffer.append(string3);
                } else if (seqInfo.isSeqOct()) {
                    String string4 = Hex.toString(byArray, n, n3, 8);
                    stringBuffer.append(string4);
                } else if (seqInfo.isSeqAsc()) {
                    int n4 = n + n3;
                    int n5 = n;
                    while (n5 < n4) {
                        stringBuffer.append((char)byArray[n5]);
                        ++n5;
                    }
                }
                if (seqInfo.isDisplaySepChar() && (n += n3) < byArray.length && (!seqInfo.isThereMore(string) || n2 >= 1)) {
                    stringBuffer.append(seqInfo.displaySepChar());
                }
                --n2;
            }
            if (n < byArray.length && seqInfo.isRepeatSepChar()) {
                stringBuffer.append(seqInfo.repeatSepChar());
            }
            n2 = 1;
            if (seqInfo.nextInfo(string, true)) continue;
            n = byArray.length;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("Valid Long test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: hex   of     0 = " + DisplayHint.stringFromHint("x", 0L));
        System.out.println(" 2: Hex   of  1234 = " + DisplayHint.stringFromHint("X", 1234L));
        System.out.println(" 3: Hex   of -1234 = " + DisplayHint.stringFromHint("X", -1234L));
        System.out.println(" 4: oct   of     0 = " + DisplayHint.stringFromHint("o", 0L));
        System.out.println(" 5: Oct   of  1234 = " + DisplayHint.stringFromHint("O", 1234L));
        System.out.println(" 6: Oct   of -1234 = " + DisplayHint.stringFromHint("O", -1234L));
        System.out.println(" 7: bin   of     0 = " + DisplayHint.stringFromHint("b", 0L));
        System.out.println(" 8: Bin   of  1234 = " + DisplayHint.stringFromHint("B", 1234L));
        System.out.println(" 9: Bin   of -1234 = " + DisplayHint.stringFromHint("B", -1234L));
        System.out.println("10: dec   of     0 = " + DisplayHint.stringFromHint("d", 0L));
        System.out.println("11: Dec   of  1234 = " + DisplayHint.stringFromHint("D", 1234L));
        System.out.println("12: Dec   of -1234 = " + DisplayHint.stringFromHint("D", -1234L));
        System.out.println("13: Dec.0 of  1234 = " + DisplayHint.stringFromHint("D-0", 1234L));
        System.out.println("14: Dec.1 of  1234 = " + DisplayHint.stringFromHint("D-1", 1234L));
        System.out.println("15: Dec.2 of  1234 = " + DisplayHint.stringFromHint("D-2", 1234L));
        System.out.println("16: Dec.3 of  1234 = " + DisplayHint.stringFromHint("D-3", 1234L));
        System.out.println("17: Dec.4 of  1234 = " + DisplayHint.stringFromHint("D-4", 1234L));
        System.out.println("18: Dec.5 of  1234 = " + DisplayHint.stringFromHint("D-5", 1234L));
        System.out.println("19: Dec.6 of  1234 = " + DisplayHint.stringFromHint("D-6", 1234L));
        System.out.println("20: Dec.0 of -1234 = " + DisplayHint.stringFromHint("D-0", -1234L));
        System.out.println("21: Dec.1 of -1234 = " + DisplayHint.stringFromHint("D-1", -1234L));
        System.out.println("22: Dec.2 of -1234 = " + DisplayHint.stringFromHint("D-2", -1234L));
        System.out.println("23: Dec.3 of -1234 = " + DisplayHint.stringFromHint("D-3", -1234L));
        System.out.println("24: Dec.4 of -1234 = " + DisplayHint.stringFromHint("D-4", -1234L));
        System.out.println("25: Dec.5 of -1234 = " + DisplayHint.stringFromHint("D-5", -1234L));
        System.out.println("26: Dec.6 of -1234 = " + DisplayHint.stringFromHint("D-6", -1234L));
        System.out.println(" ");
        System.out.println("Error Long test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: c     of     0 = " + DisplayHint.stringFromHint("c", 0L));
        System.out.println(" 2: C     of  1234 = " + DisplayHint.stringFromHint("C", 1234L));
        System.out.println(" 3: Null  of  1234 = " + DisplayHint.stringFromHint(null, 1234L));
        System.out.println(" 4: Empty of  1234 = " + DisplayHint.stringFromHint("", 1234L));
        System.out.println(" 5: d--   of     0 = " + DisplayHint.stringFromHint("d--", 0L));
        System.out.println(" 6: D--   of  1234 = " + DisplayHint.stringFromHint("D--", 1234L));
        System.out.println(" 7: d--2  of  1234 = " + DisplayHint.stringFromHint("D--2", 1234L));
        System.out.println(" 8: d+5   of  1234 = " + DisplayHint.stringFromHint("d+5", 1234L));
        System.out.println(" 9: d-a   of  1234 = " + DisplayHint.stringFromHint("d-a", 1234L));
        byte[] byArray = new byte[]{3, 0, 0, 4, -46, 0, 0, 4, -46, 0, 0, 4, -46, 77, 121, 32, 110, 97, 109, 101, 32, 105, 115, 32, 72, 97, 110, 122, 44, 32, 117, 110, 100, 32, 109, 121, 32, 110, 97, 109, 101, 32, 105, 115, 32, 70, 114, 97, 110, 122, 46, 0, 0, 4, -46, 0, 0, 4, -46, 4, 0, 0, 4, -46, 0, 0, 4, -46};
        byte[] byArray2 = new byte[]{7, -49, 3, 24, 15, 58, 19, 0};
        System.out.println(" ");
        System.out.println("Valid OctetString DateAndTIme testcases:");
        System.out.println("===============================================");
        System.out.println(" 1: 2d-1d-1d,1d:1d:1d.1d,1a1d:1d= " + DisplayHint.stringFromHint("2d-1d-1d,1d:1d:1d.1d,1a1d:1d", byArray2));
        System.out.println(" 2: 1x: = " + DisplayHint.stringFromHint("1x:", byArray2));
        System.out.println(" 3: 2x: = " + DisplayHint.stringFromHint("2x:", byArray2));
        System.out.println(" 4: 4x: = " + DisplayHint.stringFromHint("4x:", byArray2));
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Valid OctetString test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: *4x,|38a|4x;4x;*4x,  = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;*4x,", byArray));
        System.out.println(" 2: *4x,|38a|4x;4x;4x,   = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;4x,", byArray));
        System.out.println(" 3: *4x,|38a|4x;4x;*4x,! = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;*4x,!", byArray));
        System.out.println(" 4: *4x,38a4x4x*4x       = " + DisplayHint.stringFromHint("*4x,38a4x4x*4x", byArray));
        System.out.println(" 5: *4x38a4x4x*4x        = " + DisplayHint.stringFromHint("*4x38a4x4x*4x", byArray));
        System.out.println(" 6: 1x:                  = " + DisplayHint.stringFromHint("1x:", byArray));
        System.out.println(" ");
        System.out.println("Error OctetString test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: *12a,|*4x; = " + DisplayHint.stringFromHint("*12a,|*4x;", byArray));
        System.out.println(" 1: 13x,|4a;  = " + DisplayHint.stringFromHint("13x,|4a;", byArray));
    }
}

